/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.launching;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.launching.PathMappingMessages;
import com.aptana.php.debug.ui.launching.PathMappingUpdater;
import com.aptana.php.debug.ui.pathmapper.PathMapperDialog;
import com.aptana.ui.util.SWTUtils;
import com.aptana.webserver.core.IServer;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;

public class PathMappingConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String PATH_MAPPING_ICON = "/icons/full/obj16/path_mapping.gif";
    private PathMappingComposite pathMappingPreview;
    private Link debugLinkPreview;
    private ILaunchConfiguration workingCopy;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label msg1 = new Label(composite, 64);
        msg1.setText(PathMappingMessages.PathMappingConfigurationTab_mappingTableDescription);
        msg1.setLayoutData((Object)new GridData(768));
        Link link = new Link(composite, 0);
        link.setText(PathMappingMessages.PathMappingConfigurationTab_changeMappingLink);
        link.setLayoutData((Object)new GridData(768));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServer server = PathMappingConfigurationTab.this.getServer();
                if (server != null) {
                    PathMapperDialog dialog = new PathMapperDialog(PathMappingConfigurationTab.this.getShell(), server);
                    if (dialog.open() == 0) {
                        PathMappingUpdater pathMappingUpdater = new PathMappingUpdater();
                        pathMappingUpdater.updatePaths(server, new String[]{PathMappingConfigurationTab.this.workingCopy.getName()});
                        try {
                            if (PathMappingConfigurationTab.this.workingCopy.getAttribute("ATTR_USE_SPECIFIC_FILE", false) && PathMappingConfigurationTab.this.workingCopy.getAttribute("ATTR_AUTO_GENERATED_URL", false)) {
                                ILaunchConfigurationTab[] tabs;
                                PathMappingUpdater.updateConfigurations(Arrays.asList(PathMappingConfigurationTab.this.workingCopy), server);
                                ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = PathMappingConfigurationTab.this.getLaunchConfigurationDialog().getTabs();
                                int n = tabs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                                    tab.initializeFrom(PathMappingConfigurationTab.this.workingCopy);
                                    ++n2;
                                }
                            } else {
                                PathMappingConfigurationTab.this.initializeFrom(PathMappingConfigurationTab.this.workingCopy);
                            }
                        }
                        catch (CoreException ce) {
                            PHPDebugEPLPlugin.logError("Error updating the configurations", ce);
                        }
                    }
                } else {
                    MessageDialog.openInformation((Shell)PathMappingConfigurationTab.this.getShell(), (String)PathMappingMessages.PathMappingConfigurationTab_noServersDialogTitle, (String)PathMappingMessages.PathMappingConfigurationTab_noServersDialogMessage);
                }
            }
        });
        this.pathMappingPreview = new PathMappingComposite(composite, 524288, false);
        this.pathMappingPreview.setLayoutData(new GridData(1808));
        this.setControl((Control)composite);
    }

    public Image getImage() {
        return SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)PATH_MAPPING_ICON);
    }

    public String getName() {
        return PathMappingMessages.PathMappingConfigurationTab_tabName;
    }

    private IServer getServer() {
        if (this.workingCopy != null) {
            try {
                String serverName = this.workingCopy.getAttribute("ATTR_SERVER_NAME", "");
                if (!StringUtil.isEmpty((String)serverName)) {
                    return PHPServersManager.getServer((String)serverName);
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
        super.activated(workingCopy);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.workingCopy = configuration;
        if (this.pathMappingPreview != null) {
            try {
                PathMapper mapper;
                IServer server;
                String serverName = configuration.getAttribute("ATTR_SERVER_NAME", "");
                if (!StringUtil.isEmpty((String)serverName) && (server = PHPServersManager.getServer((String)serverName)) != null && (mapper = PathMapperRegistry.getByServer(server)) != null) {
                    this.pathMappingPreview.setData(mapper.getMapping());
                    return;
                }
            }
            catch (CoreException e) {
                PHPDebugEPLPlugin.logError("Error initializing the Path Mapper configuration tab", e);
            }
            this.pathMappingPreview.setData(null);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

